<?php
/**
 * @version		$Id: contact.php 14401 2010-01-26 14:10:00Z louis $
 * @package		Joomla
 * @subpackage	Contact
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses. See COPYRIGHT.php for copyright notices and
 * details.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.application.component.model');

/**
 * @package		Joomla
 * @subpackage	Contact
 */
class ContactModelContact extends JModel
{
	/**
	 * Builds the query to select contact items
	 * @param array
	 * @return string
	 * @access protected
	 */
	function _getContactQuery( &$options )
	{
		// TODO: Cache on the fingerprint of the arguments
		$db			=& JFactory::getDBO();
		//ajout gmaccess
		$user	=& JFactory::getUser();
		$checkcategory = fonctionGmaccess::checkgmdroit('com_content','read','users',$user->gmid,'category');
		$checkcontact = fonctionGmaccess::checkgmdroit('com_content','read','users',$user->gmid,'contact');
		//fin gmaccess
		
		$aid		= @$options['aid'];
		$id			= @$options['id'];
		$groupBy	= @$options['group by'];
		$orderBy	= @$options['order by'];

		$select = 'a.*, cc.access as category_access, cc.title as category_name, '
		. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug, '
		. ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(\':\', cc.id, cc.alias) ELSE cc.id END AS catslug ';
		$from	= '#__contact_details AS a';

		$joins[] = 'INNER JOIN #__categories AS cc on cc.id = a.catid';
		//ajout gmaccess
		//$joins[] =  ' LEFT JOIN #__gmacl AS gc ON a.catid = gc.axo AND gc.aco = "read" AND gc.axosection = "category"';
		//$joins[] =  ' LEFT JOIN #__gmacl AS gi ON a.id = gi.axo AND gi.aco = "read" AND gi.axosection = "contact"';
		//fin gmaccess

		$wheres[] = 'a.id = ' . (int) $id;
		$wheres[] = 'a.published = 1';
		$wheres[] = 'cc.published = 1';

		if ($aid !== null)
		{
			//$wheres[] = 'a.access <= ' . (int) $aid;
			//$wheres[] = 'cc.access <= ' . (int) $aid;
			//modif gmaccess
			//$wheres[] = ' (gc.aro IN ( '.$user->gmid.') OR cc.access <= ' . (int) $aid  . ')';
			//$wheres[] = ' (gi.aro IN ( '.$user->gmid.' ) OR a.access <= ' . (int) $aid . ')';
			$wheres[] = ' (cc.id IN ('.$checkcategory.') OR cc.access <= ' . (int) $aid  . ')';
			$wheres[] = ' (a.id IN ('.$checkcontact.') OR a.access <= ' . (int) $aid . ')';
		}

		/*
		 * Query to retrieve all categories that belong under the contacts
		 * section and that are published.
		 */
		$query = 'SELECT ' . $select .
		//modif gmaccess
		//$query = 'SELECT DISTINCTROW ' . $select .
				' FROM ' . $from .
				' '. implode ( ' ', $joins ) .
				' WHERE ' . implode( ' AND ', $wheres );

		return $query;
	}

	/**
	 * Gets a list of categories
	 * @param array
	 * @return mixed Object or null
	 */
	function getContact( $options=array() )
	{
		$query	= $this->_getContactQuery( $options );
		$result = $this->_getList( $query );
		return @$result[0];
	}
}