<?php

defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');	
$database = JFactory::getDBO();

class Status {
	var $STATUS_FAIL = 'Failed';
	var $STATUS_SUCCESS = 'Success';
	var $infomsg = array();
	var $errmsg = array();
	var $status;
}
$install_status = array();
$plg_return = gmplugin_install($this, "plugmaccess", "Plugin - GMAccess", "system", $database);
$install_status['plugin_gmaccess'] = $plg_return;
if ($plg_return->status == $plg_return->STATUS_FAIL) {
	return false;
}

	$admingmajax="";
	$sitegmajax="";
	
	if (JFolder::exists(JPATH_SITE.DS."administrator/components/com_gmaccess/ajax") && !JFolder::exists(JPATH_SITE.DS."components/com_gmajax")){
		$sitegmajax = JFolder::copy(JPATH_SITE.DS."administrator/components/com_gmaccess/ajax/site/com_gmajax", JPATH_SITE.DS."components/com_gmajax");
		//$sitegmajax="REUSSI";
	}
	if (JFolder::exists(JPATH_SITE.DS."administrator/components/com_gmaccess/ajax") && !JFolder::exists(JPATH_SITE.DS."administrator/components/com_gmajax")){
		$admingmajax = JFolder::copy(JPATH_SITE.DS."administrator/components/com_gmaccess/ajax/admin/com_gmajax", JPATH_SITE.DS."administrator/components/com_gmajax");
		//$admingmajax="REUSSI";
	}
	if (JFolder::exists(JPATH_SITE.DS."administrator/components/com_gmaccess/patchimages/site/images")){
		$siteimages = JFolder::copy(JPATH_SITE.DS."administrator/components/com_gmaccess/patchimages/site/images", JPATH_SITE.DS."images", null, true);
		//$siteimages="REUSSI";
	}
	if (JFolder::exists(JPATH_SITE.DS."administrator/components/com_gmaccess/patchimages/admin/images")){
		$adminimages = JFolder::copy(JPATH_SITE.DS."administrator/components/com_gmaccess/patchimages/admin/images", JPATH_SITE.DS."administrator/images", null, true);
		//$adminimages="REUSSI";
	}


function gmplugin_install($installer, $pluginname, $title, $group='system', $db) { 
	$status = new Status();
	$status->status = $status->STATUS_FAIL;
	
	$element =& $installer->manifest->getElementByPath($pluginname.'/files');
	if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
	    $files =& $element->children();
	    foreach ($files as $file) {
	        if ($file->attributes('plugin')) {
	            $pname = $file->attributes('plugin');
	            break;
	        }
	    }
	}
	
	if (!empty ($pname) && !empty($group)) {
	    $installer->parent->setPath('extension_root', JPATH_ROOT.DS.'plugins'.DS.$group);
	} else {
		$status->errmsg[]=JText::_('No plugin file specified');
		return $status;
	}

	/**
	 * ---------------------------------------------------------------------------------------------
	 * Filesystem Processing Section
	 * ---------------------------------------------------------------------------------------------
	 */
	
	// If the plugin directory does not exist, lets create it
	$created = false;
	if (!file_exists($installer->parent->getPath('extension_root'))) {
	    if (!$created = JFolder::create($installer->parent->getPath('extension_root'))) {
	    	$status->errmsg[]=JText::_('Failed to create directory');
			return $status;
	    }
	}

	/*
	 * If we created the plugin directory and will want to remove it if we
	 * have to roll back the installation, lets add it to the installation
	 * step stack
	 */
	if ($created) {
	    $installer->parent->pushStep(array ('type' => 'folder', 'path' => $installer->parent->getPath('extension_root')));
	}

	// Copy all necessary files
	if ($installer->parent->parseFiles($element, -1) === false) {
	    // Install failed, roll back changes
	    $installer->parent->abort();
	    $status->errmsg[]=JText::_('Unable to parse files for copying');
		return $status;
	}

	/**
	 * ---------------------------------------------------------------------------------------------
	 * Database Processing Section
	 * ---------------------------------------------------------------------------------------------
	 */	
	// Check to see if a plugin by the same name is already installed
	$query = 'SELECT `id`' .
	        ' FROM `#__plugins`' .
	        ' WHERE folder = '.$db->Quote($group) .
	        ' AND element = '.$db->Quote($pname);
	$db->setQuery($query);
	if (!$db->Query()) {
	    // Install failed, roll back changes
	    $installer->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.$db->stderr(true));
	   	$status->errmsg[]=JText::_('Unable to query Database');
		return $status;
	}
	$id = $db->loadResult();

	// Was there a plugin already installed with the same name?
	if ($id) {
	
	    if (!$installer->parent->getOverwrite())
	    {
	        // Install failed, roll back changes
	        $installer->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.JText::_('Plugin').' "'.$pname.'" '.JText::_('already exists!'));
	        $status->errmsg[]=JText::_('Plugin already is installed');
			return $status;
	    }
	
	} else {
	    $row =& JTable::getInstance('plugin');
	    $row->name = $title;
	    $row->ordering = 0;
	    $row->folder = $group;
	    $row->iscore = 1;
	    $row->access = 0;
	    $row->client_id = 0;
	    $row->element = $pname;
	    $row->published = 1;
	    $row->params = '';
	
	    if (!$row->store()) {
	        // Install failed, roll back changes
	        $installer->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.$db->stderr(true));
	        $status->errmsg[]=JText::_('Unable to write plugin information to database');
			return $status;

	    }
	}
	$status->status = $status->STATUS_SUCCESS;
	return $status;
}


?>
<h1>GMAccess Installation</h1>
<DIV class="padding"><DL id="system-message"><DD class="notice"><UL><LI><strong>Pour finaliser l'installation de GMAccess vous devez patcher les fichiers de Joomla au moyen du bouton ci-dessous. </strong> A la fin de l'installation, vous devrez vous identifier.</LI></UL></DD></DL></DIV>
<DIV class="button_holder"><DIV class="button1" style="width:120px"><DIV class="next"><a href="index.php?option=com_gmaccess&task=patchfiles">FINALISER</a></DIV></DIV></DIV>
<DIV class="padding">&nbsp; </DIV>

<table class="adminlist">
	<thead>
		<tr>
			<th class="title"><?php echo JText::_('Sous-composants'); ?></th>
			<th width="60%"><?php echo JText::_('Status'); ?></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
	</tfoot>
	<tbody>
	<?php
		$i=0; 
		foreach ( $install_status as $component => $status ) {?>
		<tr class="row<?php echo $i; ?>">
			<td class="key"><?php echo $component; ?></td>
			<td>Installation : 
				<?php echo ($status->status == $status->STATUS_SUCCESS)? ' <strong><font color="#00FF00">'.JText::_('REUSSI').'</font></strong>' : ' <em><font color="#FF0000">'.JText::_('ECHEC').'</font></em>'?>
				<?php if (count($status->errmsg) > 0 ) {
						foreach ( $status->errmsg as $errmsg ) {
       						echo '<br/>Error: ' . $errmsg;
						}
				} ?>
				<?php if (count($status->infomsg) > 0 ) {
						foreach ( $status->infomsg as $infomsg ) {
       						echo '<br/>Info: ' . $infomsg;
						}
				} ?>
			</td>
		</tr>
          <?php
			if ($i=0){ $i=1;} else {$i = 0;}; 
		?>
		<tr class="row<?php echo $i; ?>">
			<td class="key">Site com_gmajax</td>
			<td>Installation :
				<?php echo ($sitegmajax)? ' <strong><font color="#00FF00">'.JText::_('REUSSI').'</strong>' : ' <em><font color="#FF0000">'.JText::_('ECHEC').'</font></em>'?>
			</td>
		</tr>	
	<?php
			if ($i=0){ $i=1;} else {$i = 0;}; 
		}?>
		<tr class="row<?php echo $i; ?>">
			<td class="key">Admin com_gmajax</td>
			<td>Installation :
				<?php echo ($admingmajax)? ' <strong><font color="#00FF00">'.JText::_('REUSSI').'</strong>' : ' <em><font color="#FF0000">'.JText::_('ECHEC').'</font></em>'?>
			</td>
		</tr>
        <?php
			if ($i=0){ $i=1;} else {$i = 0;}; 
		?>
		<tr class="row<?php echo $i; ?>">
			<td class="key">Site images</td>
			<td>Installation :
				<?php echo ($siteimages)? ' <strong><font color="#00FF00">'.JText::_('REUSSI').'</strong>' : ' <em><font color="#FF0000">'.JText::_('ECHEC').'</font></em>'?>
			</td>
		</tr>
        <?php
			if ($i=0){ $i=1;} else {$i = 0;}; 
		?>
		<tr class="row<?php echo $i; ?>">
			<td class="key">Admin images</td>
			<td>Installation :
				<?php echo ($adminimages)? ' <strong><font color="#00FF00">'.JText::_('REUSSI').'</strong>' : ' <em><font color="#FF0000">'.JText::_('ECHEC').'</font></em>'?>
			</td>
		</tr>
      
	</tbody>
</table>

